<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\LoginRequest;
use App\Models\User;
use App\Services\AccountVerificationService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class AccountVerificationController extends Controller
{
    private $accountVerificationService;

    public function __construct(AccountVerificationService $accountVerificationService)
    {
        $this->accountVerificationService = $accountVerificationService;
    }

    public function resendVerification(LoginRequest $request): JsonResponse
    {
        $user = User::phoneOrEmail($request->input('phone'), $request->input('email'))->first();
        if ($user != null) {
            if (Auth::attempt(['email' => $user->email, 'password' => $request->input('password')])) {
                if ($user->verified) {
                    return Response::failure(__('common.error_already_verified'));
                }
                $this->accountVerificationService->create($user);
            } else {
                $user->increment('access_failed_count');
                return Response::failure(__('common.error_bad_credential'));
            }
        }
        else {
            return Response::failure(__('common.error_invalid_credential'));
        }

        return Response::success(null);
    }

    public function verifyAccountByCode(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'phone' => ['required_without:email'],
            'email' => ['required_without:phone'],
            'code' => ['required']
        ]);
        if ($validator->fails()) {
            return Response::failure($validator->errors()->first());
        }
        return $this->accountVerificationService->verifyByCode($request->input('code'), $request->input('phone'),$request->input('email'));
    }

    public function verifyAccount()
    {
        return $this->accountVerificationService->verify(request()->query('token'), request()->query('email'));
    }
}
