<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\AddressRequest;
use App\Models\Address;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class AddressController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_member');
            $this->middleware('is_active');
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Address::query()
                ->where('user_id', '=', Auth::user()->id)
                ->orderByDesc('default')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Address::query()->where('user_id', '=', Auth::user()->id)->find($id)
        );
    }

    public function store(AddressRequest $request): JsonResponse
    {
        $input = $request->validated();
        $input['user_id'] = Auth::user()->id;
        if (Address::query()->where('user_id', '=', Auth::user()->id)->count() == 0) {
            $input['default'] = true;
        } else
            $input['default'] = false;
        return Response::success(Address::query()->create($input));

    }

    public function update(AddressRequest $request, $id): JsonResponse
    {
        $address = Address::query()
            ->where('user_id', '=', Auth::user()->id)
            ->findOrFail($id);
        $input = $request->validated();
        $input['user_id'] = Auth::user()->id;
        $address->update($input);
        if ($request->input('default') == '1') {
            Address::query()
                ->where('user_id', '=', Auth::user()->id)
                ->where('id', '!=', $address->id)
                ->update(['default' => false]);
        }
        return Response::success($address);
    }

    public function destroy($id): JsonResponse
    {
        Address::query()
            ->where('user_id', '=', Auth::user()->id)
            ->findOrFail($id)
            ->delete();
        return Response::success(null);

    }
}
