<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\LoginRequest;
use App\Http\Requests\MemberRequest;
use App\Http\Requests\ResetPasswordRequest;
use App\Services\AuthService;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Throwable;

class AuthController extends Controller
{
    private $authService;

    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
        $this->middleware('auth:api')->only(['logout', 'resetPassword']);
    }

    public function register(MemberRequest $request): JsonResponse
    {
        DB::beginTransaction();
        $user = $this->authService->register($request->validated());
        DB::commit();
        return Response::success($user, 201);
    }

    public function login(LoginRequest $request): JsonResponse
    {
        DB::beginTransaction();
        $response = $this->authService->login($request->input('email'), $request->input('phone'), $request->input('password'));
        DB::commit();
        return $response;
    }

    public function logout(): JsonResponse
    {
        return $this->authService->logout();
    }

    public function resetPassword(ResetPasswordRequest $request): JsonResponse
    {
        return $this->authService->resetPassword($request->validated());
    }
}
