<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class NotificationController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_active');
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(Notification::search(request()->query('word_filter'))
            ->where('user_id', '=', Auth::user()->id)
            ->orderByDesc('notified_at'));
    }

    public function status(): JsonResponse
    {
        return response()->json([
            'seen' => Notification::query()
                ->where('user_id', '=', Auth::user()->id)
                ->where('seen', '=', '1')->count(),
            'unseen' => Notification::query()
                ->where('user_id', '=', Auth::user()->id)
                ->where('seen', '=', '0')->count(),
        ]);
    }

    public function update(): JsonResponse
    {
        Notification::query()->where('user_id', '=', Auth::user()->id)->update(['seen' => '1']);
        return response()->json(null);
    }

    public function destroy($id): JsonResponse
    {
        Notification::query()->where('user_id', '=', Auth::user()->id)->findOrFail($id)->delete();
        return response()->json(null);
    }
}
