<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\ProductCategory;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class ProductCategoryController extends Controller
{
    public function index(): JsonResponse
    {

        return Response::success(
            ProductCategory::search(request()->query('word_filter'))
                ->with(['subCategoriesRecursive'])
                ->when(request()->query('special') == null && request()->query('you_may_like') == null, function ($query) {
                    $query->whereNull('product_category_id');
                })
                ->active(true)
                ->special(request()->query('special'))
                ->youMayLike(request()->query('you_may_like'))
        );
    }
}
