<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AssociationRequest;
use App\Models\Association;
use App\Models\ProductAssociation;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class AssociationController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_association')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_association')->only(['store']);
            $this->middleware('has_permission:update_association')->only(['update']);
            $this->middleware('has_permission:delete_association')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Association::search(request()->query('word_filter'))
                ->orderByDesc('sort')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Association::query()->find($id)
        );
    }

    public function store(AssociationRequest $request): JsonResponse
    {
        $input = $request->validated();
        return Response::success(Association::query()->create($input));

    }

    public function update(AssociationRequest $request, $id): JsonResponse
    {
        $association = Association::query()
            ->findOrFail($id);
        $association->update($request->validated());
        return Response::success($association);
    }

    public function destroy($id): JsonResponse
    {
        $association = Association::query()->findOrFail($id);
        if (ProductAssociation::query()->where('association_id', '=', $id)->count() > 0) {
            return Response::failure(__('common.error_delete_item'));
        }
        $association->forceDelete();
        return Response::success(null);
    }
}
