<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class ForceUpdate
{
    private $VERSION = 'app-version';
    private $LANG = 'app-lang';
    private $PLATFORM = 'app-version';

    private $minimumVersion = 200;

    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $appVersion = null;
        if ($request->query('User-Agent') != null) {
            foreach (explode(';', $request->query('User-Agent')) as $item) {
                $param = explode(':', $item);
                if (Str::contains($param[0], $this->VERSION)) {
                    $appVersion = intval(str_replace('.','',$param[1]));
                }

            }
            if ($appVersion !== null && $this->minimumVersion !== null && $this->minimumVersion > $appVersion) {
                return response()->json(['error' => __('common.error_old_version',
                    ['current_version' => $appVersion,'new_version' => $this->minimumVersion])], 400);
            }
        }
        return $next($request);
    }
}
