<?php


namespace App\Http\Traits;

use Illuminate\Support\Str;

trait HasSort
{
    public function scopeWithSort($query, string $default = null)
    {
        $sortArr = explode(',', request()->input('sort', ','));
        $column = $sortArr[0];
        $direction = Str::lower($sortArr[1] ?? 'asc');
        return $query->when($column && in_array($direction, ['asc', 'desc'])
            , fn($query) => $query->orderBy($column, $direction)
            , fn($query) => $query->when($default, fn($query) => $query->orderByRaw($default)));
    }
}
