<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AppPreference extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'orders' => 'boolean',
        'promotions' => 'boolean',
        'others' => 'boolean',
        'emails' => 'boolean'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
