<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryOption extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = ['id'];

    protected $appends = [
        'pickup',
        'delivery'
    ];
    protected $casts = [
        'pickup' => 'boolean',
        'delivery' => 'boolean'
    ];

    public function getPickupAttribute(): bool
    {
        return $this->type === 'pickup';
    }

    public function getDeliveryAttribute(): bool
    {
        return $this->type === 'delivery';
    }
}
