<?php

namespace App\Models;

use App\Http\Traits\HasCurrency;
use App\Http\Traits\HasSearch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


class Order extends Model
{
    use HasFactory, SoftDeletes, HasSearch, HasCurrency;

    protected $guarded = ['id'];

    protected $casts = [
        'deliverable' => 'boolean'
    ];

    /*



    public function getTaxAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getDiscountTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getCouponTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getDeliveryTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getShippingTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }*/

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    public function address(): BelongsTo
    {
        return $this->belongsTo(Address::class, 'address_id', 'id')->withTrashed();
    }

    public function billingAddress(): BelongsTo
    {
        return $this->belongsTo(Address::class, 'billing_address_id', 'id')->withTrashed();
    }

    public function shippingAddress(): BelongsTo
    {
        return $this->belongsTo(Address::class, 'shipping_address_id', 'id')->withTrashed();
    }

    public function seller(): BelongsTo
    {
        return $this->belongsTo(Seller::class)->withTrashed();
    }

    public function payment(): BelongsTo
    {
        return $this->belongsTo(Payment::class)->withTrashed();
    }

    public function deliveryOption(): BelongsTo
    {
        return $this->belongsTo(DeliveryOption::class)->withTrashed();
    }

    public function coupon(): BelongsTo
    {
        return $this->belongsTo(Coupon::class)->withTrashed();
    }

    public function delivery(): BelongsTo
    {
        return $this->belongsTo(User::class, 'delivery_id', 'id')->withTrashed();
    }

    public function orderItems(): HasMany
    {
        return $this->HasMany(OrderItem::class)->withTrashed();
    }

    public function warehouse(): BelongsTo
    {
        return $this->belongsTo(Warehouse::class)->withTrashed();
    }


    public function scopeNumberFilter($query, $number)
    {
        return $query->when($number !== null, function ($query) use ($number) {
            $query->where('number', 'LIKE', "%$number%");
        });
    }

    public function scopeUserFilter($query, $userId)
    {
        return $query->when($userId !== null, function ($query) use ($userId) {
            $query->where('user_id', '=', $userId);
        });
    }

    public function scopeCurrencyFilter($query, $currency)
    {
        return $query->when($currency !== null, function ($query) use ($currency) {
            $query->where('currency', 'LIKE', "%$currency%");
        });
    }

    public function scopeDateFilter($query, $from, $to)
    {
        return $query->when($from !== null && $to !== null, function ($query) use ($from, $to) {
            $query->whereDate('date', '>=', $from)->whereDate('date', '<=', $to);
        });
    }
    public function scopeTimeFilter($query, $from, $to)
    {
        return $query->when($from !== null && $to !== null, function ($query) use ($from, $to) {
            $query->whereTime('date', '>=', $from)->whereTime('date', '<=', $to);
        });
    }

    public function scopeStateFilter($query, $state)
    {
        return $query->when($state != null && in_array($state,['new', 'approved', 'cancelled', 'assigned_to_delivery', 'ongoing', 'delivered']), function ($query) use ($state) {
            $query->where('state', '=', $state);
        });
    }

    public function scopePaymentStateFilter($query, $state)
    {
        return $query->when($state != null && in_array($state,['awaiting', 'paid', 'refunded', 'cancelled']), function ($query) use ($state) {
            $query->where('payment_state', '=', $state);
        });
    }
}
