<?php


namespace App\Services;


use App\Models\Coupon;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Response;

class CouponService
{
    private $notificationService;


    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    public function create(string $timezone, array &$data): Collection
    {
        $members = User::query()
            ->where('role', 'member')
            ->where('accepted', '=', true)
            ->where('activated', '=', true)
            ->get();
        $coupons = [];

        $data['creation'] = Carbon::now($timezone)->toDateTimeString();
        if ($data['active'] == '1') {
            if (Coupon::query()->where('code', '=', $data['code'])->where('active', '=', 1)->count() > 0) {
                throw new HttpResponseException(Response::failure(__('common.error_active_coupon_exists')));
            }
        }
        $data['expiration'] = Carbon::parse($data['expiration'])->toDateTimeString();
        $data['code_group'] = uniqid($data['code'] . time(), true);
        foreach ($members as $member) {
            $data['timezone'] = $member->timezone;
            $data['user_id'] = $member->id;
            array_push($coupons, $data);
            if ($data['for_marketing'] == '0' && $data['active'] == '1') {
                if (!$data['on_delivery_cost']) {
                    $discountCodeValue = $data['amount'] == null ? ($data['percentage'] . '%') : $data['amount'];
                    $this->notificationService->send('common.msg_new_discount'
                        , 'common.msg_new_discount_body'
                        , $member
                        , ['code' => $data['code'], 'amount' => $discountCodeValue, 'body' => $data['title'] == null ? "" : "(" . $data['title'] . ")"]
                        , NotificationService::OTHERS
                    );
                } else {
                    $this->notificationService->send('common.msg_new_discount'
                        , 'common.msg_new_delivery_discount_body'
                        , $member
                        , ['code' => $data['code'], 'body' => $data['title'] == null ? "" : "(" . $data['title'] . ")"]
                        , NotificationService::OTHERS
                    );
                }
            }
        }
        Coupon::query()->insert($coupons);
        return collect($coupons);
    }

    public function assignExistingCoupons($user)
    {
        $coupons = Coupon::query()
            ->whereDate('expiration', '>=', Carbon::now($user->timezone)->toDateTimeString())
            ->where('active', '=', '1')
            ->get();
        $couponsInsert = [];
        foreach ($coupons->groupBy('code') as $key => $value) {
            array_push($couponsInsert, [
                'title' => $value[0]['title'],
                'body' => $value[0]['body'],
                'percentage' => $value[0]['percentage'],
                'amount' => $value[0]['amount'],
                'expiration' => $value[0]['expiration'],
                'code' => $key,
                'for_marketing' => $value[0]['for_marketing'],
                'on_delivery_cost' => $value[0]['on_delivery_cost'],
                'active' => '1',
                'used' => '0',
                'timezone' => $user->timezone,
                'creation' => Carbon::now($user->timezone)->toDateTimeString(),
                'user_id' => $user->id,
            ]);
        }
        Coupon::query()->insert($couponsInsert);
    }
}
