<?php


namespace App\Services;


use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;

class NotificationService
{
    public const OTHERS = 'others';
    public const PROMOTIONS = 'promotions';
    public const ORDERS = 'orders';
    private $FCMService;

    public function __construct(FCMService $FCMService)
    {
        $this->FCMService = $FCMService;
    }

    public function send($title, $body, $receiver, array $replacement, string $type, bool $save = true)
    {
        if (!in_array($type, ['others', 'promotions', 'orders'])) {
            return;
        }
        if ($type === 'others' && $receiver->appPreference->others == '0') {
            return;
        }
        if ($type === 'promotions' && $receiver->appPreference->promotions == '0') {
            return;
        }
        if ($type === 'orders' && $receiver->appPreference->orders == '0') {
            return;
        }
        $notification['notification']['title'] = __($title, $replacement, $receiver->locale);
        $notification['notification']['body'] = __($body, $replacement, $receiver->locale);
        $notification['notification']['icon'] = config('app.url').'/assets/images/icon/logo.png';
        if ($save) {
            Notification::query()->create([
                'title' => __($title, $replacement, 'en'),
                'title_ar' => __($title, $replacement, 'ar'),
                'body' => __($body, $replacement, 'en'),
                'body_ar' => __($body, $replacement, 'ar'),
                'notified_at' => Carbon::now($receiver->timezone),
                'user_id' => $receiver->id,
                'pivot' => false,
            ]);
        }
        $this->FCMService->send($receiver->firebase_token, $notification);
    }

    public function sendToRole(string $timezone, $type, array &$data): Collection
    {
        $users = User::query()->whereNotNull('firebase_token')->where('role', $data['role'])->active(true)->get();
        $regIDs = [];
        $notifications = [];
        $currentTime = Carbon::now($timezone);
        $notification['notification']['title'] = $data['title'];
        $notification['notification']['body'] = $data['body'];
        $notification['notification']['icon'] = config('app.url').'/assets/images/icon/logo.png';
        $group = uniqid(time(), true);
        array_push($notifications, [
            'title' => $data['title']
            , 'title_ar' => $data['title']
            , 'body' => $data['body']
            , 'body_ar' => $data['body']
            , 'icon' => config('app.url').'/assets/images/icon/logo.png'
            , 'notified_at' => $currentTime
            , 'role' => $data['role']
            , 'pivot' => true
            , 'group' => $group
            , 'user_id' => null
            , 'created_at' => Carbon::now()
            , 'updated_at' => Carbon::now()
        ]);
        foreach ($users as $user) {
            if ($type === 'others' && $user->appPreference->others == '0') {
                continue;
            }
            if ($type === 'promotions' && $user->appPreference->promotions == '0') {
                continue;
            }
            if ($type === 'orders' && $user->appPreference->orders == '0') {
                continue;
            }
            array_push($regIDs, $user->firebase_token);
            array_push($notifications, [
                'title' => $data['title']
                , 'title_ar' => $data['title']
                , 'body' => $data['body']
                , 'body_ar' => $data['body']
                , 'icon' => config('app.url').'/assets/images/icon/logo.png'
                , 'notified_at' => Carbon::now($user->timezone)
                , 'role' => $data['role']
                , 'pivot' => false
                , 'group' => $group
                , 'user_id' => $user->id
                , 'created_at' => Carbon::now()
                , 'updated_at' => Carbon::now()

            ]);
        }
        Notification::query()->insert($notifications);
        $this->FCMService->sendMultiple($regIDs, $notification);
        return collect($regIDs);
    }
}
