<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSellersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sellers', function (Blueprint $table) {
            $table->id();
            $table->timestamp('supplier_since')->nullable();
            $table->text('corporation_name')->nullable();
            $table->decimal('longitude', 17, 14, false)->nullable();
            $table->decimal('latitude', 17, 14, false)->nullable();
            $table->string('description_en', 300)->nullable();
            $table->string('description_ar', 300)->nullable();
            $table->string('address_en', 300)->nullable();
            $table->string('address_ar', 300)->nullable();
            $table->unsignedBigInteger('deleted')->default(0);
            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sellers');
    }
}
