<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['Offline', 'Tap Checkout']);
            $table->text('name_en');
            $table->text('name_ar');
            $table->text('description_en')->nullable();
            $table->text('description_ar')->nullable();
            $table->text('instructions_en')->nullable();
            $table->text('instructions_ar')->nullable();
            $table->text('publishable_key')->nullable();
            $table->text('secret_key')->nullable();
            $table->boolean('activated')->default(1);
            $table->unsignedBigInteger('deleted')->default(0);
            $table->softDeletes();
            $table->unique(['type', 'deleted']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
