<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'يجب قبول حقل :attribute',
    'active_url' => 'حقل :attribute لا يُمثّل رابطًا صحيحًا',
    'after' => 'يجب على حقل :attribute أن يكون تاريخًا لاحقًا للتاريخ :date.',
    'after_or_equal' => 'حقل :attribute يجب أن يكون تاريخاً لاحقاً أو مطابقاً للتاريخ :date.',
    'alpha' => 'يجب أن لا يحتوي حقل :attribute سوى على حروف',
    'alpha_dash' => 'يجب أن لا يحتوي حقل :attribute على حروف، أرقام ومطّات.',
    'alpha_num' => 'يجب أن يحتوي :attribute على حروفٍ وأرقامٍ فقط',
    'array' => 'يجب أن يكون حقل :attribute ًمصفوفة',
    'before' => 'يجب على حقل :attribute أن يكون تاريخًا سابقًا للتاريخ :date.',
    'before_or_equal' => 'حقل :attribute يجب أن يكون تاريخا سابقا أو مطابقا للتاريخ :date',
    'between' => [
        'numeric' => 'يجب أن تكون قيمة :attribute بين :min و :max.',
        'file' => 'يجب أن يكون حجم الملف :attribute بين :min و :max كيلوبايت.',
        'string' => 'يجب أن يكون عدد حروف النّص :attribute بين :min و :max',
        'array' => 'يجب أن يحتوي :attribute على عدد من العناصر بين :min و :max',
    ],
    'boolean' => 'يجب أن تكون قيمة حقل :attribute إما true أو false ',
    'confirmed' => 'حقل التأكيد غير مُطابق للحقل :attribute',
    'date' => 'حقل :attribute ليس تاريخًا صحيحًا',
    'date_format' => 'لا يتوافق حقل :attribute مع الشكل :format.',
    'different' => 'يجب أن يكون حقلان :attribute و :other مُختلفان',
    'digits' => 'يجب أن يحتوي حقل :attribute على :digits رقمًا/أرقام',
    'digits_between' => 'يجب أن يحتوي حقل :attribute بين :min و :max رقمًا/أرقام ',
    'dimensions' => 'الـ :attribute يحتوي على أبعاد صورة غير صالحة.',
    'distinct' => 'للحقل :attribute قيمة مُكرّرة.',
    'email' => 'يجب أن يكون :attribute عنوان بريد إلكتروني صحيح البُنية',
    'exists' => 'حقل :attribute لاغٍ',
    'file' => 'الـ :attribute يجب أن يكون من ملفا.',
    'filled' => 'حقل :attribute إجباري',
    'image' => 'يجب أن يكون حقل :attribute صورةً',
    'in' => 'حقل :attribute لاغٍ',
    'in_array' => 'حقل :attribute غير موجود في :other.',
    'integer' => 'يجب أن يكون حقل :attribute عددًا صحيحًا',
    'ip' => 'يجب أن يكون حقل :attribute عنوان IP ذا بُنية صحيحة',
    'ipv4' => 'يجب أن يكون حقل :attribute عنوان IPv4 ذا بنية صحيحة.',
    'ipv6' => 'يجب أن يكون حقل :attribute عنوان IPv6 ذا بنية صحيحة.',
    'json' => 'يجب أن يكون حقل :attribute نصا من نوع JSON.',
    'max' => [
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أصغر لـ :max.',
        'file' => 'يجب أن لا يتجاوز حجم الملف :attribute :max كيلوبايت',
        'string' => 'يجب أن لا يتجاوز طول نص :attribute :max حروفٍ/حرفًا',
        'array' => 'يجب أن لا يحتوي حقل :attribute على أكثر من :max عناصر/عنصر.',
    ],
    'mimes' => 'يجب أن يكون حقل ملفًا من نوع : :values.',
    'mimetypes' => 'يجب أن يكون حقل ملفًا من نوع : :values.',
    'min' => [
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أكبر لـ :min.',
        'file' => 'يجب أن يكون حجم الملف :attribute على الأقل :min كيلوبايت',
        'string' => 'يجب أن يكون طول نص :attribute على الأقل :min حروفٍ/حرفًا',
        'array' => 'يجب أن يحتوي حقل :attribute على الأقل على :min عُنصرًا/عناصر',
    ],
    'not_in' => 'حقل :attribute لاغٍ',
    'numeric' => 'يجب على حقل :attribute أن يكون رقمًا',
    'present' => 'يجب تقديم حقل :attribute',
    'regex' => 'صيغة حقل :attribute .غير صحيحة',
    'required' => 'حقل :attribute مطلوب.',
    'required_if' => 'حقل :attribute مطلوب في حال ما إذا كان :other يساوي :value.',
    'required_unless' => 'حقل :attribute مطلوب في حال ما لم يكن :other يساوي :values.',
    'required_with' => 'حقل :attribute إذا توفّر :values.',
    'required_with_all' => 'حقل :attribute إذا توفّر :values.',
    'required_without' => 'حقل :attribute إذا لم يتوفّر :values.',
    'required_without_all' => 'حقل :attribute إذا لم يتوفّر :values.',
    'same' => 'يجب أن يتطابق حقل :attribute مع :other',
    'size' => [
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية لـ :size',
        'file' => 'يجب أن يكون حجم الملف :attribute :size كيلوبايت',
        'string' => 'يجب أن يحتوي النص :attribute على :size حروفٍ/حرفًا بالظبط',
        'array' => 'يجب أن يحتوي حقل :attribute على :size عنصرٍ/عناصر بالظبط',
    ],
    'string' => 'يجب أن يكون حقل :attribute نصآ.',
    'timezone' => 'يجب أن يكون :attribute نطاقًا زمنيًا صحيحًا',
    'unique' => 'قيمة حقل :attribute مُستخدمة من قبل',
    'uploaded' => 'فشل في تحميل الـ :attribute',
    'url' => 'صيغة الرابط :attribute غير صحيحة',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'lt' => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
    ],
    'lte' => [
        'numeric' => 'The :attribute must be less than or equal :value.',
        'file' => 'The :attribute must be less than or equal :value kilobytes.',
        'string' => 'The :attribute must be less than or equal :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
    ],
    'multiple_of' => 'The :attribute must be a multiple of :value',
    'not_regex' => 'The :attribute format is invalid.',
    'password' => 'The password is incorrect.',
    'starts_with' => 'The :attribute must start with one of the following: :values.',
    'uuid' => 'The :attribute must be a valid UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'first_name' => 'الاسم الأول',
        'last_name' => 'الاسم الثاني',
        'email' => 'البريد الالكتروني',
        'phone' => 'رقم الموبايل',
        'email_verified_at' => 'تاريخ تأكيد البريد الالكتروني',
        'timezone' => 'المنطقة الزمنية',
        'locale' => 'اللغة',
        'last_ip' => 'عنوان الدخول الأخير',
        'gender' => 'الجنس',
        'birth_date' => 'تاريخ الميلاد',
        'password' => 'كلمة المرور',
        'image' => 'الصورة',
        'firebase_token' => 'رمز فايربيز',
        'activated' => 'مفعل',
        'accepted' => 'مقبول',
        'verified' => 'مؤكد',
        'is_logged_in' => 'مسجل دخول',
        'access_failed_count' => 'عدد مرات فشل الدخول',
        'last_login_date' => 'تاريخ آخر تسجيل دخول',
        'role' => 'الدور',
        'city_id' => 'المدينة',
        'token' => 'الرمز',
        'orders' => 'إشعارات الطلبات',
        'others' => 'إشعارات أخرى',
        'emails' => 'إشعارات البريد الالكتروني',
        'image_quality' => 'جودة الصورة',
        'user_id' => 'المستخدم',
        'text_ar' => 'النص باللغة العربية',
        'text_en' => 'النص باللغة الانجليزية',
        'address' => 'العنوان',
        'facebook' => 'رابط فيسبوك',
        'instagram' => 'رابط انستغرام',
        'twitter' => 'رابط تويتتر',
        'apple' => 'رابط أبل',
        'google' => 'رابط جوجل',
        'website_link' => 'رابط الموقع',
        'name_en' => 'الاسم باللغة الانجليزية',
        'name_ar' => 'الاسم باللغة العربية',
        'special' => 'مميز',
        'date' => 'التاريخ',
        'name' => 'الاسم',
        'phone_number' => 'رقم الموبايل',
        'message' => 'الرسالة',
        'title' => 'العنوان',
        'body' => 'النص',
        'code' => 'الرمز',
        'percentage' => 'النسبة المئوية',
        'amount' => 'المبلغ',
        'creation' => 'تاريخ الانشاء',
        'expiration' => 'تاريخ الانتهاء',
        'used' => 'مستخدم',
        'for_marketing' => 'تسويق الكتروني',
        'on_delivery_cost' => 'على سعر التوصيل',
        'type' => 'النوع',
        'cost' => 'التكلفة',
        'estimated_hours' => 'الساعات المتوقعة',
        'question_ar' => 'السؤال باللغة العربية',
        'question_en' => 'السؤال باللغة الانجليزية',
        'answer_en' => 'الإجابة باللغة الانجليزية',
        'answer_ar' => 'الإجابة باللغة العربية',
        'users_verification' => 'التحقق من حسابات المستخدمين',
        'description_en' => 'التوصيف باللغة الانجليزية',
        'description_ar' => 'التوصيف باللغة العربية',
        'you_may_like' => 'يمكن أن تعجبك',
        'seen' => 'مشاهد',
        'title_ar' => 'العنوان باللغة العربية',
        'title_en' => 'العنوان باللغة الانجليزية',
        'body_ar' => 'النص باللغة العربية',
        'icon' => 'الأيقونة',
        'notified_at' => 'تاريخ الإشعار',
        'short_description_en' => 'التوصيف القصير باللغة الانجليزية',
        'short_description_ar' => 'التوصيف القصير باللغة العربية',
        'meta_tag_title_en' => 'عنوان الميتا تاغ باللغة الانجليزية',
        'meta_tag_title_ar' => 'عنوان الميتا تاغ باللغة العربية',
        'meta_tag_keywords_en' => 'كلمات الميتا باللغة الانجليزية',
        'meta_tag_keywords_ar' => 'كلمات الميتا باللغة العربية',
        'tags' => 'الوسومات',
        'seo' => 'SEO',
        'best_collection' => 'أفضل الأصناف',
        'newly_added' => 'وصل حديثاً',
        'flash_deal' => 'صفقات عاجلة',
        'selected' => 'مختار',
        'barcode' => 'باركود',
        'sku' => 'وحدة حفظ الأوراق المالية',
        'location' => 'الموقع',
        'latitude' => 'خط العرض',
        'longitude' => 'خط الطول',
        'price' => 'السعر',
        'quantity' => 'السؤال',
        'min_quantity' => 'الحد الأدنى من الكمية',
        'max_quantity' => 'الحد الأقصى من الكمية',
        'subtract_stock' => 'ينقص من الكمية',
        'shipping_timing' => 'توقيت الشحن',
        'requires_shipping' => 'يتطلب شحن',
        'availability_date' => 'تاريخ التوفر',
        'length_class' => 'فئة الطول',
        'dimensions' => 'الأبعاد',
        'weight_class' => 'فئة الوزن',
        'weight' => 'الوزن',
        'discount' => 'الحسم',
        'special_offer' => 'عرض خاص',
        'sort' => 'الترتيب',
        'video' => 'الفيديو',
        'images' => 'الصور',
        'required_points' => 'النقاط المطلوبة',
        'brand_id' => 'الماركة',
        'seller_id' => 'البائع',
        'out_of_stock_id' => 'حالة عدم التوفر في المخزن',
        'deleted' => 'محذوف',
        'delivery_option_id' => 'خيار التوصيل',
        'product_id' => 'المنتج',
        'attribute_id' => 'الخاصية',
        'value_en' => 'القيمة باللغة الانجليزية',
        'value_ar' => 'القيمة باللغة العربية',
        'association_id' => 'الارتباط',
        'product_association_id' => 'ارتباط المنتج',
        'category_id' => 'التصنيف',
        'hex' => 'رقم اللون',
        'payment_id' => 'الدفع',
        'region' => 'المنطقة',
        'district' => 'منطقة',
        'street_address' => 'عنوان الشارع',
        'boulevard' => 'الجادة',
        'house' => 'المنزل',
        'apartment' => 'الشقة',
        'company' => 'الشركة',
        'province' => 'الاقامة',
        'floor' => 'الدور',
        'city' => 'المدينة',
        'postal_code' => 'الرمز البريدي',
        'default' => 'افتراضي',
        'country_id' => 'البلد',
        'supplier_since' => 'مزود من تاريخ',
        'corporation_name' => 'اسم المؤسسة',
        'number' => 'رقم الطلب',
        'state' => 'حالة الطلب',
        'total' => 'المجموع النهائي',
        'subtotal' => 'سعر القطع',
        'tax' => 'الضريبة',
        'currency' => 'العملة',
        'total_quantity' => 'الكمية الاجمالية',
        'notes' => 'الملاحظات',
        'discount_total' => 'اجمالي الحسم',
        'coupon_total' => 'اجمالي الكوبون',
        'deliverable' => 'فابل للتوصيل',
        'delivery_assign_date' => 'تاريخ الاسناد الى موصل',
        'delivered_date' => 'تاريخ التوصيل',
        'delivery_method' => 'طريقة التوصيل',
        'delivery_total' => 'اجمالي التوصيل',
        'delivery_time' => 'وقت التوصيل',
        'delivery_distance' => 'مسافة التوصيل',
        'post_process' => 'معالجة لاحقة',
        'post_url' => 'رابط المعالجة اللاحقة',
        'payment_state' => 'حالة الدفع',
        'tap_token' => 'رمز تاب',
        'tap_id' => 'معرف تاب',
        'shipping_state' => 'حالة الشحن',
        'shipped_date' => 'تاريخ الشحن',
        'shipping_total' => 'اجمالي الشحن',
        'delivery_id' => 'الموصل',
        'billing_address_id' => 'عنوان الدفع',
        'shipping_address_id' => 'عنوان الشحن',
        'coupon_id' => 'الحسم',
        'order_id' => 'الطب',
        'unit_name_en' => 'اسم الوحدة باللغة العربية',
        'unit_name_ar' => 'اسم الوحدة باللغة الانجليزية',
        'unit_dimensions' => 'أبعاد الوحدة',
        'unit_weight' => 'وزن الوحدة',
        'unit_price' => 'سعر الوحدة',
        'unit_discount' => 'حسم الوحدة',
        'unit_special_offer' => 'عرض الوحدة',
        'unit_image' => 'صورة الوحدة',
        'unit_color' => 'لون الوحدة',
        'unit_size' => 'حجم الوحدة',
        'subtracted' => 'مطروح',
        'brand_name_en' => 'اسم الماركة باللغة الانجليزية',
        'brand_name_ar' => 'اسم الماركة باللغة العربية',
        'purchased_with_points' => 'تم الشراء باستخدام النقاط',
        'points' => 'النقاط',
        'special_offer_total' => 'اجمالي العرض',
        'comment' => 'التعليق',
        'rating' => 'التقييم',
    ]

];
