<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\ForgotPasswordRequest;
use App\Http\Requests\ResetForgotPasswordRequest;
use App\Services\AccountRecoveryService;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;

class AccountRecoveryController extends Controller
{
    private $accountRecoveryService;


    public function __construct(AccountRecoveryService $accountRecoveryService)
    {
        $this->accountRecoveryService = $accountRecoveryService;
        $this->middleware('auth:api')->only(['resetForgotPasswordByCode']);
        $this->middleware('is_active')->only(['resetForgotPasswordByCode']);
    }

    public function forgotPassword(ForgotPasswordRequest $request): JsonResponse
    {
        return $this->accountRecoveryService->forgotPassword($request->input('email'), $request->input('phone'));
    }

    public function resetForgotPassword()
    {
        return $this->accountRecoveryService->resetForgotPassword(request()->query('token'), request()->query('email'));
    }

    public function resetForgotPasswordByCode(ResetForgotPasswordRequest $request): JsonResponse
    {
        return $this->accountRecoveryService->resetForgotPasswordByCode(Auth::user(), $request->input('code'), $request->input('new_password'));
    }
}
