<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class CouponController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_member');
            $this->middleware('is_active');
        }
    }

    public function index(): JsonResponse
    {
        $user = Auth::user();
        return Response::success(Coupon::search(request()->query('word_filter'))
            ->forMarketing(request()->query('expired_filter'))
            ->validNow(request()->query('valid_now'))
            ->where('user_id', '=', $user->id));
    }

    public function getByCode($code): JsonResponse
    {
        $user = Auth::user();
        return Response::success(Coupon::query()
            ->where('user_id', '=', $user->id)
            ->where('code', '=', $code)
            ->firstOrFail());
    }
}
