<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\MemberRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Khsing\World\Models\City;

class UserController extends Controller
{


    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_active');
        }
    }

    public function show(): JsonResponse
    {
        return Response::success(
            Auth::user()->load(['city', 'appPreference'])
        );
    }

    public function update(MemberRequest $request): JsonResponse
    {
        $user = Auth::user();
        $appPreferenceInput = ['orders', 'promotions', 'others', 'emails', 'image_quality'];
        $userInput = Arr::except($request->validated(), $appPreferenceInput);
        if ($request->filled('city_id'))
        {
            $userInput['timezone'] = City::query()->find($request->input('city_id'))->country->timezone;
        }
        $user->update($userInput);
        $user->appPreference()->update(Arr::only($request->validated(), $appPreferenceInput));
        return Response::success($user->load(['city', 'appPreference']));
    }
    public function destroy():JsonResponse
    {
        $user=Auth::user();
        $user->delete();
        return Response::success([]);
    }
}
