<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AboutRequest;
use App\Models\About;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class AboutController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api');
        $this->middleware('has_permission:view_about')->only(['index']);
        $this->middleware('has_permission:update_about')->only(['update']);
    }

    public function index(): JsonResponse
    {
        return Response::success(About::query()->first());
    }

    public function update(AboutRequest $request): JsonResponse
    {
        $about = About::query()->first();
        if ($about == null) {
            return Response::success(About::query()->create($request->validated()));
        } else {
            $about->update($request->validated());
            return Response::success($about);
        }
    }
}
