<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\BrandRequest;
use App\Models\Brand;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class BrandController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_brand')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_brand')->only(['store']);
            $this->middleware('has_permission:update_brand')->only(['update']);
            $this->middleware('has_permission:delete_brand')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Brand::search(request()->query('word_filter'))
                ->active(request()->query('activated'))
                ->special(request()->query('special'))
                ->orderBy('sort')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Brand::query()->with([])->find($id)
        );
    }

    public function store(BrandRequest $request): JsonResponse
    {
        $input = $request->validated();
        $input['activated'] = $input['accepted'] = true;
        return Response::success(Brand::query()->create($input)->load([]));

    }

    public function update(BrandRequest $request, $id): JsonResponse
    {
        $brand = Brand::query()
            ->findOrFail($id);
        $brand->update($request->validated());
        return Response::success($brand->load([]));
    }

    public function destroy($id): JsonResponse
    {
        Brand::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
