<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ColorRequest;
use App\Models\Color;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class ColorController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:create_product')->only(['store']);
            $this->middleware('has_permission:update_product')->only(['update']);
            $this->middleware('has_permission:delete_product')->only(['delete']);
        }
    }

    public function store(ColorRequest $request): JsonResponse
    {
        $color = Color::query()->create($request->validated());
        return Response::success($color);
    }

    public function update(ColorRequest $request, $id): JsonResponse
    {
        $color = Color::query()
            ->findOrFail($id);
        $color->update($request->validated());
        return Response::success($color);
    }

    public function destroy($id): JsonResponse
    {
        Color::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
