<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Khsing\World\Models\City;

class DeliveryController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_delivery')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_delivery')->only(['store']);
            $this->middleware('has_permission:update_delivery')->only(['update']);
            $this->middleware('has_permission:delete_delivery')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            User::search(request()->query('word_filter'))
                ->phoneFilter(request()->query('phone_filter'))
                ->active(request()->query('activated'))
                ->delivery()
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            User::query()->delivery()->with(['city', 'appPreference'])->find($id)
        );
    }

    public function store(UserRequest $request): JsonResponse
    {
        DB::beginTransaction();
        $userInput = $request->validated();
        $userInput['verified'] = $userInput['activated'] = '1';
        $userInput['timezone'] = City::query()->find($request->input('city_id'))->country->timezone;
        $userInput['role'] = 'Delivery';
        $user = User::query()->create($userInput);
        DB::commit();

        return Response::success($user->load(['city', 'appPreference']));

    }

    public function update(UserRequest $request, $id): JsonResponse
    {
        //DB::enableQueryLog();
        $user = User::query()
            ->delivery()
            ->findOrFail($id);
        $userInput = $request->validated();
        $userInput['timezone'] = City::query()->find($request->input('city_id'))->country->timezone;
        $user->update($userInput);
        return Response::success($user->load(['city', 'appPreference']));
        //return Response::success(DB::getQueryLog());
    }

    public function destroy($id): JsonResponse
    {
        DB::beginTransaction();
        User::query()->findOrFail($id)->delete();
        DB::commit();
        return Response::success(null);

    }
}
