<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\DeliveryOptionRequest;
use App\Models\DeliveryOption;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class DeliveryOptionController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_deliveryOption')->only(['index', 'show']);
            $this->middleware('has_permission:create_deliveryOption')->only(['store']);
            $this->middleware('has_permission:update_deliveryOption')->only(['update']);
            $this->middleware('has_permission:delete_deliveryOption')->only(['destroy']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            DeliveryOption::query()->get()
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            DeliveryOption::query()->find($id)
        );
    }

    public function store(DeliveryOptionRequest $request): JsonResponse
    {
        return Response::success(DeliveryOption::query()->create($request->validated())->load([]));

    }

    public function update(DeliveryOptionRequest $request, $id): JsonResponse
    {
        $deliveryOption = DeliveryOption::query()
            ->findOrFail($id);
        $deliveryOption->update($request->validated());
        return Response::success($deliveryOption);
    }

    public function destroy($id): JsonResponse
    {
        DeliveryOption::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
