<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ReviewRequest;
use App\Models\Review;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class ReviewController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_review')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_review')->only(['store']);
            $this->middleware('has_permission:update_review')->only(['update']);
            $this->middleware('has_permission:delete_review')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Review::search(request()->query('word_filter'))
                ->state(request()->query('state_filter'))
                ->orderByDesc('date')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Review::query()->with(['product', 'user'])->find($id)
        );
    }

    public function store(ReviewRequest $request): JsonResponse
    {
        $input = $request->validated();
        $input['state'] = 'accepted';
        $input['date'] = Carbon::now(Auth::user()->timezone);
        return Response::success(Review::query()->create($input));
    }

    public function update(ReviewRequest $request, $id): JsonResponse
    {
        $review = Review::query()
            ->findOrFail($id);
        $input = $request->validated();
        $input['date'] = Carbon::now(Auth::user()->timezone);
        $review->update($input);
        return Response::success($review->load(['product', 'user']));
    }

    public function destroy($id): JsonResponse
    {
        Review::query()->findOrFail($id)->delete();
        return Response::success(null);
    }
}
