<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\RoleRequest;
use App\Models\Role;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;

class RoleController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:configure_role');
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Role::query()
                ->whereNotIn('id', [1, 2, 3, 4, 5])
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Role::query()
                ->with(['permissions'])
                ->whereNotIn('id', [1, 2, 3, 4, 5])
                ->find($id)
        );
    }

    public function store(RoleRequest $request): JsonResponse
    {
        DB::beginTransaction();
        $role = Role::query()->create(Arr::except($request->validated(), ['permissions']));
        $role->permissions()->sync($request->input('permissions'));
        DB::commit();
        return Response::success($role->load(['permissions']));
    }

    public function update(RoleRequest $request, $id): JsonResponse
    {
        $role = Role::query()
            ->whereNotIn('id', [1, 2, 3, 4, 5])
            ->findOrFail($id);
        $role->update(Arr::except($request->validated(), ['permissions']));
        $role->permissions()->sync($request->input('permissions'));
        return Response::success($role->load(['permissions']));
    }

    public function destroy($id): JsonResponse
    {
        DB::beginTransaction();
        $role = Role::query()->whereNotIn('id', [1, 2, 3, 4, 5])->findOrFail($id);
        if ($role->users()->count() > 0)
            return Response::failure(__('common.error_delete_role'));
        $role->delete();
        DB::commit();
        return Response::success(null);

    }
}
