<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\SliderRequest;
use App\Models\Slider;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class SliderController extends Controller
{
    public function baseQuery(string $type='main')
    {
        return Slider::query()
            ->where('type','=',$type)
            ->with('category.subCategoriesRecursive')
            ->withSort()
            ->get();
    }
    public function indexMain():JsonResponse
    {
        return Response::success($this->baseQuery());
    }
    public function indexSecondary():JsonResponse
    {
        return Response::success($this->baseQuery('secondary'));
    }
    public function show(Slider $slider)
    {
        return Response::success($slider->load('category.subCategoriesRecursive'));
    }
    public function store(SliderRequest $request)
    {
        return Response::success(Slider::query()->create($request->validated()));
    }
    public function update(SliderRequest $request,Slider $slider)
    {
        $slider->update($request->validated());
        return Response::success($slider->refresh());
    }
    public function destroy(Slider $slider)
    {
        return Response::success($slider->delete());
    }
}
