<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\BrandRequest;
use App\Http\Requests\WarehouseRequest;
use App\Models\Address;
use App\Models\Brand;
use App\Models\Warehouse;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Response;

class WarehouseController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api');
        $this->middleware('has_permission:view_warehouse')->only(['index', 'export', 'show']);
        $this->middleware('has_permission:create_warehouse')->only(['store']);
        $this->middleware('has_permission:update_warehouse')->only(['update']);
        $this->middleware('has_permission:delete_warehouse')->only(['delete']);
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Warehouse::search(request()->query('word_filter'))

        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Warehouse::query()->find($id)
        );
    }

    public function store(WarehouseRequest $request): JsonResponse
    {
        return Response::success(Warehouse::query()->create($request->validated()));

    }

    public function update(WarehouseRequest $request, $id): JsonResponse
    {
        $warehouse = Warehouse::query()
            ->findOrFail($id);
        $warehouse->update($request->validated());
        return Response::success($warehouse);
    }

    public function destroy($id): JsonResponse
    {
        Warehouse::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
