<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;

class CouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        if ($this->getMethod() == 'PUT') {
            return [
                'code' => [
                    'required'
                ],
                'code_group' => [
                    'required'
                ],
                'active' => [
                    'required',
                    'boolean'
                ]
            ];
        }
        return [
            'title' => [
                'nullable'
            ],
            'body' => [
                'nullable'
            ],
            'percentage' => [
                'required_without:amount'
            ],
            'amount' => [
                'required_without:percentage'
            ],
            'expiration' => [
                'required',
                'date_format:Y-m-d H:i:s'
            ],
            'code' => [
                'required',
                'min:3',
                'max:200'
            ],
            'for_marketing' => [
                'required',
                'boolean'
            ],
            'on_delivery_cost' => [
                'required',
                'boolean'
            ],
            'active' => [
                'required',
                'boolean'
            ]
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
