<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class DeliveryOptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $validations = [
            'estimated_hours' => [
                'sometimes',
                'nullable',
//                'integer'
            ],
            'cost' => [
                'required',
                'numeric'
            ],
            'type' => [
                'sometimes',
                'nullable',
                Rule::in(['pickup', 'delivery'])
            ]
        ];
        if ($this->getMethod() == 'POST') {
            return array_merge($validations, [
                'name_ar' => ['required', Rule::unique('delivery_options')->where('deleted', 0)],
                'name_en' => ['required', Rule::unique('delivery_options')->where('deleted', 0)],
            ]);
        }

        return array_merge($validations, [
            'name_ar' => ['required', Rule::unique('delivery_options')
                ->where('deleted', 0)->ignore(request()->route('id'))],
            'name_en' => ['required', Rule::unique('delivery_options')
                ->where('deleted', 0)->ignore(request()->route('id'))],
        ]);
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
