<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class ProductCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        if ($this->getMethod() === 'PATCH') {
            return [
                'special' => [
                    'required',
                    'boolean'
                ],
                'you_may_like' => [
                    'sometimes',
                    'nullable',
                    'boolean'
                ]
            ];
        }
        return [
            'name_en' => ['required', 'different:name_ar'],
            'name_ar' => ['required', 'different:name_en'],
            'description_en' => ['nullable'],
            'description_ar' => ['nullable'],
            'image' => 'nullable',
            'product_category_id' => ['nullable', Rule::exists('product_categories', 'id')
                ->where('deleted', 0)],
            'activated' => 'required|boolean',
            'special' => [
                'sometimes',
                'nullable',
//                'boolean'
            ],
            'you_may_like' => [
                'sometimes',
                'nullable',
//                'boolean'
            ]
        ];

    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
