<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class RoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        if ($this->getMethod() == 'POST')
            return [
                'name_en' => ['required', 'between:3,50', Rule::unique('roles')],
                'name_ar' => ['required', 'between:3,50', Rule::unique('roles')],
                'permissions' => ['required', 'array'],
                'permissions.*' => ['required', 'integer', Rule::exists('permissions', 'id')]
            ];
        return [
            'name_en' => ['required', 'between:3,50', Rule::unique('roles')->ignore(request()->route('id'))],
            'name_ar' => ['required', 'between:3,50', Rule::unique('roles')->ignore(request()->route('id'))],
            'permissions' => ['required', 'array'],
            'permissions.*' => ['required', 'integer', Rule::exists('permissions', 'id')]
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
