<?php


namespace App\Http\Traits;


use Illuminate\Support\Str;

trait HasCurrency
{
    public function convertCurrency($value)
    {
        $userCurrency = request()->query('currency');
        if (Str::contains(request()->getRequestUri(), '/admin/')) {
            $userCurrency = 'USD';
        }
        if ($userCurrency == null) {
            $geo = geoip(request()->ip());
            $userCurrency = ($geo !== null && $geo->currency !== null) ? $geo->currency : 'USD';
        }
        return currency($value, 'USD', $userCurrency, false);
    }
}
