<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentReport extends Mailable
{
    use Queueable, SerializesModels;

    public $order, $tapChargeId, $chargeToken, $status;

    public function __construct($order, $tapChargeId, $chargeToken, $status)
    {
        $this->order = $order;
        $this->tapChargeId = $tapChargeId;
        $this->chargeToken = $chargeToken;
        $this->status = $status;
    }


    public function build(): PaymentReport
    {
        return $this->subject('TalabatExpress Payment Report')->view('order_payment_failure');
    }
}
