<?php

namespace App\Models;

use App\Http\Traits\HasUniqueSoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class AttributeGroup extends Model
{
    use HasFactory, SoftDeletes, HasUniqueSoftDeletes;

    protected $guarded = ['id'];

    public function attributes(): HasMany
    {
        return $this->hasMany(Attribute::class);
    }
}
