<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CartItem extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'purchased_with_points' => 'boolean',
        'unit_dimensions' => 'array',
        'unit_discount' => 'array',
        'unit_special_offer' => 'array',
        'unit_image' => 'array',
        'unit_color' => 'array',
    ];

    protected $appends = [
        'formatted_unit_price',
        'formatted_unit_discount',
        'formatted_tax',
        'formatted_total',
    ];

    public function getTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getUnitPriceAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getTaxAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getUnitDiscountAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getFormattedTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedUnitPriceAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedTaxAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedUnitDiscountAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function cart(): BelongsTo
    {
        return $this->belongsTo(Cart::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
