<?php

namespace App\Models;

use App\Http\Traits\HasSearch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\MassPrunable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Notification extends Model
{
    use HasFactory, HasSearch, MassPrunable;

    protected $guarded = ['id'];

    protected $searchable = [
        'title',
        'title_ar',
        'body',
        'body_ar'
    ];

    public function prunable()
    {
        return static::where('notified_at', '<=', now()->subRealHours(72));
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
