<?php

namespace App\Models;

use App\Http\Traits\HasMediaImage;
use App\Http\Traits\HasSearch;
use App\Http\Traits\HasUniqueSoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;

class ProductCategory extends Model implements HasMedia
{
    use HasFactory, SoftDeletes, HasUniqueSoftDeletes, HasSearch, HasMediaImage;

    protected $guarded = ['id'];

    protected $searchable = [
        'name_en',
        'name_ar'
    ];
    protected $casts = [
        'accepted' => 'boolean',
        'activated' => 'boolean',
        'image' => 'array',
        'special' => 'boolean',
        'you_may_like' => 'boolean'
    ];

    public function scopeActive($query, $active)
    {
        return $query->when($active !== null, function ($query) use ($active) {
            $query->where('activated', '=', boolval($active));
        });
    }

    public function scopeSpecial($query, $special)
    {
        return $query->when($special !== null, function ($query) use ($special) {
            $query->where('special', '=', $special == '1' || $special == 1 || $special == true || $special == 'true' ? '1' : '0');
        });
    }

    public function scopeYouMayLike($query, $youMayLike)
    {
        return $query->when($youMayLike !== null, function ($query) use ($youMayLike) {
            $query->where('you_may_like', '=', $youMayLike == '1' || $youMayLike == 1 || $youMayLike == true || $youMayLike == 'true' ? '1' : '0');
        });
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(ProductCategory::class, 'product_category_id', 'id');
    }

    public function subCategories(): HasMany
    {
        return $this->hasMany(ProductCategory::class, 'product_category_id', 'id');
    }

    public function subCategoriesRecursive(): HasMany
    {
        return $this->hasMany(ProductCategory::class, 'product_category_id', 'id')->with('subCategoriesRecursive');
    }

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(ProductCategory::class, 'category_product');
    }
}
