<?php

namespace App\Models;

use App\Http\Traits\HasMediaImage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;

class Seller extends Model implements HasMedia
{
    use HasFactory, SoftDeletes, HasMediaImage;

    protected $guarded = ['id'];

    protected $casts = [
        'image' => 'array'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeActive($query, $active)
    {
        return $query->when($active !== null, function ($query) use ($active) {
            $query->whereHas('user', function ($query) use ($active) {
                $query->where('activated', '=', boolval($active));
            });
        });
    }
}
