<?php

namespace App\Models;

use App\Http\Traits\HasSearch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class Warehouse extends Model
{
    use HasFactory, SoftDeletes, HasSearch;

    protected $guarded = ['id'];

    protected $searchable = [
        'name_en',
        'name_ar',
        'description_ar',
        'description_en',
        'phone_number'
    ];

    public function order(): HasOne
    {
        return $this->hasOne(Order::class)->withTrashed();
    }
}
