<?php


namespace App\Providers;


use App\Mail\PaymentReport;
use App\Services\MailService;
use App\Services\NotificationService;

class SendFailureNotification
{
    private $notificationService;
    private $mailService;

    public function __construct(NotificationService $notificationService, MailService $mailService)
    {
        $this->notificationService = $notificationService;
        $this->mailService = $mailService;
    }

    /**
     * Handle the event.
     *
     * @param OrderPlaced $event
     * @return void
     */
    public function handle(OrderPaymentFailed $event)
    {
        if ($event->order != null)
        {
            $this->notificationService->send(__('common.message_order_payment_failed'), __('common.message_payment_failed_body'), $event->order->user, [], NotificationService::ORDERS);
            $this->mailService->sendToUser($event->order->user, new PaymentReport($event->order, $event->tapChargeId, $event->tapChargeToken, $event->status));
        }
    }
}
