<?php


namespace App\Services;

class FCMService
{
    public function send($to, array $fcmFields)
    {
        $fcmFields['to'] = $to;
        return self::sendNotificationRequest($fcmFields);
    }

    private function sendNotificationRequest($fields)
    {
        // Set POST variables
        $url = 'https://fcm.googleapis.com/fcm/send';

        $headers = array(
            'Authorization: key=' . config('app.FCM_SERVER_KEY'),
            'Content-Type: application/json'
        );
        // Open connection
        $ch = curl_init();

        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);

        return json_decode($result);
    }

    public function sendToTopic($topicName, array $fcmFields)
    {
        $fcmFields['to'] = '/topics/' . $topicName;
        return self::sendNotificationRequest($fcmFields);
    }

    public function sendMultiple($registration_ids, array $fcmFields)
    {
        $fcmFields['registration_ids'] = $registration_ids;
        return self::sendNotificationRequest($fcmFields);
    }

    public function createGroup($groupName, $registration_ids)
    {
        $fcmFields = array(
            'operation' => 'create',
            'notification_key_name' => $groupName,
            'registration_ids' => $registration_ids
        );
        return self::sendGroupRequest($fcmFields);
    }

    private function sendGroupRequest($fields)
    {
        $url = 'https://fcm.googleapis.com/fcm/notification';

        $headers = array(
            'Authorization: key=' . config('app.FCM_SERVER_KEY'),
            'project_id: ' . config('app.FCM_SENDER_ID'),
            'Content-Type: application/json'
        );
        // Open connection
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);

        return json_decode($result);
    }

    public function addToGroup($groupName, $key, $registration_ids)
    {
        $fcmFields = array(
            'operation' => 'add',
            'notification_key_name' => $groupName,
            'notification_key' => $key,
            'registration_ids' => $registration_ids
        );
        return self::sendGroupRequest($fcmFields);
    }

    public function removeFromGroup($groupName, $key, $registration_ids)
    {
        $fcmFields = array(
            'operation' => 'add',
            'notification_key_name' => $groupName,
            'notification_key' => $key,
            'registration_ids' => $registration_ids
        );
        return self::sendGroupRequest($fcmFields);
    }
}
