<?php


namespace App\Services;


use Illuminate\Support\Collection;

class PermissionDependencyService
{
    private $DEPENDENCY = [
        'product' => [
            'association',
            'attribute',
            'category',
            'brand',
            'deliveryOption',
            'outOfStock',
            'payment',
            'review',
            'seller'
        ],
        'user' => [
            'country'
        ],
        'seller' => [
            'country'
        ],
        'delivery' => [
            'country'
        ],
        'review' => [
            'user',
            'product'
        ],

    ];

    public function handle(Collection &$permissions)
    {
        foreach ($permissions as $permission) {
            $type = explode('_', $permission);
            if ($type[0] == 'update' || $type[0] == 'create' || $type[0] == 'delete') {
                $permissions->push("view_$type[1]");
            }
            if (array_key_exists($type[1], $this->DEPENDENCY)) {
                foreach ($this->DEPENDENCY[$type[1]] as $dependencyPermission) {
                    $permissions->push("view_$dependencyPermission");
                }
            }
        }
    }
}
