<?php


namespace App\Services;


use App\Models\Color;
use App\Models\Product;
use App\Models\ProductAssociation;
use App\Models\Size;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;

class ProductService
{
    public function create(array $data)
    {
        $productInput = Arr::except($data, [
            'product_discount',
            'product_special_offer',
            'attributes',
            'options',
            'available_payment',
            'available_delivery_options'
        ]);
        $product = Product::query()->create(array_merge($productInput, [
            'timezone' => Auth::user()->timezone
        ]));
        /* if ($data['product_discount'] !== null) {
             ProductDiscount::query()->create(array_merge($data['product_discount'], [
                 'timezone' => Auth::user()->timezone,
                 'product_id' => $product->id
             ]));
         }
         if ($data['product_special_offer'] !== null) {
             ProductSpecialOffer::query()->create(array_merge($data['product_special_offer'], [
                 'timezone' => Auth::user()->timezone,
                 'product_id' => $product->id
             ]));
         }
        */
        $product->categories()->sync($data['categories']);
        $product->availableDeliveryOptions()->sync($data['available_delivery_options']);
        $product->availablePayments()->sync($data['available_payment']);
        if (array_key_exists('attributes', $data) && $data['attributes'] !== null) {
            foreach ($data['attributes'] as $attribute) {
                $product->attributes()->attach([$attribute['attribute_id'] => [
                    "value_en" => $attribute['value_en'],
                    "value_ar" => $attribute['value_ar']
                ]]);
            }
        }
        if (array_key_exists('associations', $data) && $data['associations'] !== null) {
            foreach ($data['associations'] as $association) {
                $assocProducts = array_diff(array_unique($association['products']), [$product->id]);
                if (count($assocProducts) > 0) {
                    $pa = ProductAssociation::query()->create([
                        'association_id' => $association['association_id'],
                        'product_id' => $product->id
                    ]);
                    $pa->products()->sync($assocProducts);
                }
            }
        }
        if (array_key_exists('colors', $data) && $data['colors'] !== null) {
            foreach ($data['colors'] as $color) {
                $color['product_id'] = $product->id;
                Color::query()->create($color);
            }
        }
        if (array_key_exists('sizes', $data) && $data['sizes'] !== null) {
            foreach ($data['sizes'] as $size) {
                $size['product_id'] = $product->id;
                Size::query()->create($size);
            }
        }
        return $product;
    }

    public function update(array $data, $id)
    {
        $productInput = Arr::except($data, [
            'product_discount',
            'product_special_offer',
            'attributes',
            'options',
            'available_payment',
            'available_delivery_options'
        ]);
        $product = Product::withTrashed()
            ->findOrFail($id);
        $product->categories()->sync($data['categories']);
        $product->availableDeliveryOptions()->sync($data['available_delivery_options']);
        $product->availablePayments()->sync($data['available_payment']);
        $product->attributes()->detach();
        if (array_key_exists('attributes', $data) && $data['attributes'] !== null) {
            foreach ($data['attributes'] as $attribute) {
                $product->attributes()->attach([$attribute['attribute_id'] => [
                    "value_en" => $attribute['value_en'],
                    "value_ar" => $attribute['value_ar']
                ]]);
            }
        }
        ProductAssociation::query()->where('product_id', '=', $id)->delete();
        if (array_key_exists('associations', $data) && $data['associations'] !== null) {
            foreach ($data['associations'] as $association) {
                $pa = ProductAssociation::query()->create([
                    'association_id' => $association['association_id'],
                    'product_id' => $id
                ]);
                $pa->products()->sync(array_diff(array_unique($association['products']), [$id]));
            }
        }

        /*ProductDiscount::query()->where('product_id', '=', $id)->delete();
        if ($data['product_discount'] !== null) {
            ProductDiscount::query()->create(array_merge($data['product_discount'], [
                'timezone' => Auth::user()->timezone,
                'product_id' => $id
            ]));
        }
        ProductSpecialOffer::query()->where('product_id', '=', $id)->delete();
        if ($data['product_special_offer'] !== null) {
            ProductSpecialOffer::query()->create(array_merge($data['product_special_offer'], [
                'timezone' => Auth::user()->timezone,
                'product_id' => $id
            ]));
        }
        $product->attributes()->detach();
        if ($data['attributes'] !== null) {
            foreach ($data['attributes'] as $attribute) {
                $product->attributes()->attach([$attribute['id'] => [
                    "value_en" => $attribute['value_en'],
                    "value_ar" => $attribute['value_ar']
                ]]);
            }
        }
        $product->productOptions()->delete();
        if ($data['options'] !== null) {
            foreach ($data['options'] as $option) {
                $p = ProductOption::query()->create([
                    'option_id' => $option['option_id'],
                    'product_id' => $id,
                    'required' => $option['required']
                ]);
                foreach ($option['product_option_values'] as $value) {
                    $p->values()->attach([$value['option_value_id'] => [
                        'quantity' => $value['quantity'],
                        'subtract_stock' => $value['subtract_stock'],
                        'price_diff' => $value['price_diff'],
                        'required_points_diff' => $value['required_points_diff'],
                        'weight_diff' => $value['weight_diff'],
                    ]]);
                }
            }
        }
        */
        $product->update(array_merge($productInput, [
            'timezone' => Auth::user()->timezone
        ]));
        return $product;
    }
}
