<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBrandsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('brands', function (Blueprint $table) {
            $table->id();
            $table->string('name_en', 150);
            $table->string('name_ar', 150);
            $table->json('image')->nullable();
            $table->boolean('activated')->nullable();
            $table->boolean('accepted')->nullable();
            $table->boolean('special')->default(false);
            $table->unsignedBigInteger('sort')->default(0);
            $table->unsignedBigInteger('deleted')->default(0);
            $table->softDeletes();
            $table->unique(['name_en', 'deleted']);
            $table->unique(['name_ar', 'deleted']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('brands');
    }
}
