<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryOptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_options', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['pickup', 'delivery']);
            $table->string('name_ar', 150);
            $table->string('name_en', 150);
            $table->bigInteger('estimated_hours');
            $table->float('cost', 8, 3)->default(0);

            $table->unsignedBigInteger('deleted')->default(0);
            $table->unique(['name_en', 'deleted']);
            $table->unique(['name_ar', 'deleted']);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_options');
    }
}
