<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->text('title_ar');
            $table->text('body')->nullable();
            $table->text('body_ar')->nullable();
            $table->text('icon')->nullable();
            $table->enum('role', ['Super Admin', 'Admin', 'Seller', 'Member', 'Delivery']);
            $table->timestamp('notified_at')->nullable();
            $table->boolean('seen')->default(0);
            $table->boolean('pivot')->default(0);
            $table->text('group')->nullable();
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('CASCADE');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
