<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->text('name_en');
            $table->text('name_ar');
            $table->text('short_description_en')->nullable();
            $table->text('short_description_ar')->nullable();
            $table->text('description_en')->nullable();
            $table->text('description_ar')->nullable();
            $table->text('meta_tag_title_en')->nullable();
            $table->text('meta_tag_title_ar')->nullable();
            $table->json('meta_tag_keywords_en')->nullable();
            $table->json('meta_tag_keywords_ar')->nullable();
            $table->json('tags')->nullable();
            $table->json('seo')->nullable();
            $table->boolean('best_collection')->default(false);
            $table->boolean('newly_added')->default(false);
            $table->boolean('flash_deal')->default(false);
            $table->boolean('selected')->default(false);
            $table->text('delivery_estimation')->nullable();

            $table->text('code');
            $table->text('barcode');
            $table->text('sku');
            $table->text('location');
            $table->decimal('latitude', 17, 14, false)->nullable();
            $table->decimal('longitude', 17, 14, false)->nullable();
            $table->float('price', 30, 3);
            $table->integer('quantity')->default(1);
            $table->integer('min_quantity')->default(1);
            $table->integer('max_quantity')->nullable();
            $table->boolean('subtract_stock')->default(true);
            //$table->enum('out_of_stock_status', ['2-3 Days', 'In Stock', 'Out of Stock', 'Pre-Order'])->default('Out of Stock');
            $table->text('shipping_timing')->nullable();
            $table->boolean('requires_shipping')->default(true);
            $table->timestamp('availability_date');
            $table->enum('length_class', ['Millimeter', 'Inch', 'Centimeter'])->nullable()->default('Millimeter');
            $table->json('dimensions')->nullable();
            $table->enum('weight_class', ['Gram', 'Kilogram', 'Pound', 'Ounce'])->nullable()->default('Kilogram');
            $table->float('weight')->nullable();
            $table->json('discount')->nullable();
            $table->json('special_offer')->nullable();


            $table->boolean('activated')->nullable();
            $table->boolean('accepted')->nullable();

            $table->integer('sort')->nullable();
            $table->text('video')->nullable();
            $table->json('image')->nullable();
            $table->json('images');
            $table->integer('required_points')->default(0);
            $table->string('timezone', 30)->nullable();

            $table->bigInteger('brand_id')->unsigned()->nullable();
            $table->foreign('brand_id')->references('id')->on('brands');
            $table->bigInteger('seller_id')->unsigned()->nullable();
            $table->foreign('seller_id')->references('id')->on('sellers');
            $table->bigInteger('out_of_stock_id')->unsigned()->nullable();
            $table->foreign('out_of_stock_id')->references('id')->on('out_of_stocks');
            $table->unsignedBigInteger('deleted')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
