<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->id();
            $table->text('first_name')->nullable();
            $table->text('last_name', 50)->nullable();
            $table->text('phone', 50)->nullable();
            $table->text('region')->nullable();
            $table->text('district')->nullable();
            $table->text('street_address', 100)->nullable();
            $table->text('boulevard')->nullable();
            $table->text('house')->nullable();
            $table->text('apartment')->nullable();
            $table->text('company')->nullable();
            $table->text('province')->nullable();
            $table->text('floor')->nullable();
            $table->text('city');
            $table->text('postal_code', 20)->nullable();
            $table->decimal('longitude', 17, 14, false)->nullable();
            $table->decimal('latitude', 17, 14, false)->nullable();
            $table->boolean('default')->default(0);
            $table->bigInteger('country_id')->unsigned()->nullable();
            $table->foreign('country_id')->references('id')->on('world_countries');
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('addresses');
    }
}
