<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->timestamp('date');
            $table->float('total', 12, 3);
            $table->float('subtotal', 12, 3);
            $table->float('tax', 10, 3)->default(0);
            $table->string('currency', 10);
            $table->unsignedInteger('total_quantity');
            $table->text('notes')->nullable();
            $table->float('discount_total', 12, 3);

            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->bigInteger('delivery_option_id')->unsigned()->nullable();
            $table->foreign('delivery_option_id')->references('id')->on('delivery_options');
            $table->bigInteger('coupon_id')->unsigned()->nullable();
            $table->foreign('coupon_id')->references('id')->on('coupons');
            $table->bigInteger('seller_id')->nullable()->unsigned();
            $table->foreign('seller_id')->references('id')->on('sellers');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
}
